<!-- business information here -->
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <!-- <link rel="stylesheet" href="style.css"> -->
        <title>Receipt-{{$receipt_details->invoice_no}}</title>
    </head>
    <body>
        <div class="ticket border-bottom-dotted" style="margin-top: 1px !important">
        	
        	
        	@if(!empty($receipt_details->logo))
        		<div class="text-box centered">
        			<img style="max-height: 100px; width: auto;" src="{{$receipt_details->logo}}" alt="Logo">
        		</div>
        	@endif
        	<div class="text-box">
        	<!-- Logo -->
            <p class="centered">
            	<!-- Header text -->
            	@if(!empty($receipt_details->header_text))
            		<span class="headings"style="font-size: 16px;font-weight: bold;">{!! $receipt_details->header_text !!}</span>
					<br/>
				@endif

				<!-- business information here -->
					<br/>
				@if(!empty($receipt_details->display_name))
					<span class="headings" style="font-size: 16px;font-weight: bold;">
						{{$receipt_details->display_name}}
					</span>
					<br/>
				@endif
				
				@if(!empty($receipt_details->address))
					<span class="headings" style="font-size: 10px;font-weight: bold;">{!! $receipt_details->address !!}
						</span>
					<br/>
				@endif

				@if(!empty($receipt_details->contact))
				<span class="headings" style="font-size: 10px;font-weight: bold;">
					{!! $receipt_details->contact !!}
					</span>
				@endif
				@if(!empty($receipt_details->contact) && !empty($receipt_details->website))
					, 
				@endif
				@if(!empty($receipt_details->website))
					{{ $receipt_details->website }}
				@endif
				@if(!empty($receipt_details->location_custom_fields))
					<br>{{ $receipt_details->location_custom_fields }}
				@endif

				@if(!empty($receipt_details->sub_heading_line1))
					{{ $receipt_details->sub_heading_line1 }}<br/>
				@endif
				@if(!empty($receipt_details->sub_heading_line2))
					{{ $receipt_details->sub_heading_line2 }}<br/>
				@endif
				@if(!empty($receipt_details->sub_heading_line3))
					{{ $receipt_details->sub_heading_line3 }}<br/>
				@endif
				@if(!empty($receipt_details->sub_heading_line4))
					{{ $receipt_details->sub_heading_line4 }}<br/>
				@endif		
				@if(!empty($receipt_details->sub_heading_line5))
					{{ $receipt_details->sub_heading_line5 }}<br/>
				@endif

				@if(!empty($receipt_details->tax_info1))
					<br><b>{{ $receipt_details->tax_label1 }}</b> {{ $receipt_details->tax_info1 }}
				@endif

				@if(!empty($receipt_details->tax_info2))
					<b>{{ $receipt_details->tax_label2 }}</b> {{ $receipt_details->tax_info2 }}
				@endif

				<!-- Title of receipt -->
				@if(!empty($receipt_details->invoice_heading))
					<br/><span class="sub-headings">{!! $receipt_details->invoice_heading !!}</span>
				@endif
			</p>
			</div>
			<div class="border-top textbox-info" style="margin-left: 2px ">
				<p class="f-left"><strong>{!! $receipt_details->invoice_no_prefix !!}</strong></p>
				<p class="f-right">
					{{$receipt_details->invoice_no}}
				</p>
			</div>
			<div class="textbox-info">
				<p class="f-left"><strong>{!! $receipt_details->date_label !!}</strong></p>
				<p class="f-right">
					{{$receipt_details->invoice_date}}
				</p>
			</div>
			
			@if(!empty($receipt_details->due_date_label))
				<div class="textbox-info">
					<p class="f-left"><strong>{{$receipt_details->due_date_label}}</strong></p>
					<p class="f-right">{{$receipt_details->due_date ?? ''}}</p>
				</div>
			@endif

			@if(!empty($receipt_details->sales_person_label))
				<div class="textbox-info">
					<p class="f-left"><strong>{{$receipt_details->sales_person_label}}</strong></p>
				
					<p class="f-right">{{$receipt_details->sales_person}}</p>
				</div>
			@endif
			@if(!empty($receipt_details->commission_agent_label))
				<div class="textbox-info">
					<p class="f-left"><strong>{{$receipt_details->commission_agent_label}}</strong></p>
				
					<p class="f-right">{{$receipt_details->commission_agent}}</p>
				</div>
			@endif

			@if(!empty($receipt_details->brand_label) || !empty($receipt_details->repair_brand))
				<div class="textbox-info">
					<p class="f-left"><strong>{{$receipt_details->brand_label}}</strong></p>
				
					<p class="f-right">{{$receipt_details->repair_brand}}</p>
				</div>
			@endif

			@if(!empty($receipt_details->device_label) || !empty($receipt_details->repair_device))
				<div class="textbox-info">
					<p class="f-left"><strong>{{$receipt_details->device_label}}</strong></p>
				
					<p class="f-right">{{$receipt_details->repair_device}}</p>
				</div>
			@endif
			
			@if(!empty($receipt_details->model_no_label) || !empty($receipt_details->repair_model_no))
				<div class="textbox-info">
					<p class="f-left"><strong>{{$receipt_details->model_no_label}}</strong></p>
				
					<p class="f-right">{{$receipt_details->repair_model_no}}</p>
				</div>
			@endif
			
			@if(!empty($receipt_details->serial_no_label) || !empty($receipt_details->repair_serial_no))
				<div class="textbox-info">
					<p class="f-left"><strong>{{$receipt_details->serial_no_label}}</strong></p>
				
					<p class="f-right">{{$receipt_details->repair_serial_no}}</p>
				</div>
			@endif

			@if(!empty($receipt_details->repair_status_label) || !empty($receipt_details->repair_status))
				<div class="textbox-info">
					<p class="f-left"><strong>
						{!! $receipt_details->repair_status_label !!}
					</strong></p>
					<p class="f-right">
						{{$receipt_details->repair_status}}
					</p>
				</div>
        	@endif

        	@if(!empty($receipt_details->repair_warranty_label) || !empty($receipt_details->repair_warranty))
	        	<div class="textbox-info">
	        		<p class="f-left"><strong>
	        			{!! $receipt_details->repair_warranty_label !!}
	        		</strong></p>
	        		<p class="f-right">
	        			{{$receipt_details->repair_warranty}}
	        		</p>
	        	</div>
        	@endif

        	<!-- Waiter info -->
			@if(!empty($receipt_details->service_staff_label) || !empty($receipt_details->service_staff))
	        	<div class="textbox-info">
	        		<p class="f-left"><strong>
	        			{!! $receipt_details->service_staff_label !!}
	        		</strong></p>
	        		<p class="f-right">
	        			{{$receipt_details->service_staff}}
					</p>
	        	</div>
	        @endif

	        @if(!empty($receipt_details->table_label) || !empty($receipt_details->table))
	        	<div class="textbox-info">
	        		<p class="f-left"><strong>
	        			@if(!empty($receipt_details->table_label))
							<b>{!! $receipt_details->table_label !!}</b>
						@endif
	        		</strong></p>
	        		<p class="f-right">
	        			{{$receipt_details->table}}
	        		</p>
	        	</div>
	        @endif

	        <!-- customer info -->
	        <div class="textbox-info">
	        	<p style="vertical-align: top;"><strong>
	        		{{$receipt_details->customer_label ?? ''}}
	        	</strong></p>

	        	<p>
	        		@if(!empty($receipt_details->customer_info))
	        			<div class="bw">
						{!! $receipt_details->customer_info !!}
						</div>
					@endif
	        	</p>
	        </div>
			
			@if(!empty($receipt_details->client_id_label))
				<div class="textbox-info">
					<p class="f-left"><strong>
						{{ $receipt_details->client_id_label }}
					</strong></p>
					<p class="f-right">
						{{ $receipt_details->client_id }}
					</p>
				</div>
			@endif
			
			@if(!empty($receipt_details->customer_tax_label))
				<div class="textbox-info">
					<p class="f-left"><strong>
						{{ $receipt_details->customer_tax_label }}
					</strong></p>
					<p class="f-right">
						{{ $receipt_details->customer_tax_number }}
					</p>
				</div>
			@endif

			@if(!empty($receipt_details->customer_custom_fields))
				<div class="textbox-info">
					<p class="centered">
						{!! $receipt_details->customer_custom_fields !!}
					</p>
				</div>
			@endif
			
			@if(!empty($receipt_details->customer_rp_label))
				<div class="textbox-info">
					<p class="f-left"><strong>
						{{ $receipt_details->customer_rp_label }}
					</strong></p>
					<p class="f-right">
						{{ $receipt_details->customer_total_rp }}
					</p>
				</div>
			@endif
			@if(!empty($receipt_details->shipping_custom_field_1_label))
				<div class="textbox-info">
					<p class="f-left"><strong>
						{!!$receipt_details->shipping_custom_field_1_label!!} 
					</strong></p>
					<p class="f-right">
						{!!$receipt_details->shipping_custom_field_1_value ?? ''!!}
					</p>
				</div>
			@endif
			@if(!empty($receipt_details->shipping_custom_field_2_label))
				<div class="textbox-info">
					<p class="f-left"><strong>
						{!!$receipt_details->shipping_custom_field_2_label!!} 
					</strong></p>
					<p class="f-right">
						{!!$receipt_details->shipping_custom_field_2_value ?? ''!!}
					</p>
				</div>
			@endif
			@if(!empty($receipt_details->shipping_custom_field_3_label))
				<div class="textbox-info">
					<p class="f-left"><strong>
						{!!$receipt_details->shipping_custom_field_3_label!!} 
					</strong></p>
					<p class="f-right">
						{!!$receipt_details->shipping_custom_field_3_value ?? ''!!}
					</p>
				</div>
			@endif
			@if(!empty($receipt_details->shipping_custom_field_4_label))
				<div class="textbox-info">
					<p class="f-left"><strong>
						{!!$receipt_details->shipping_custom_field_4_label!!} 
					</strong></p>
					<p class="f-right">
						{!!$receipt_details->shipping_custom_field_4_value ?? ''!!}
					</p>
				</div>
			@endif
			@if(!empty($receipt_details->shipping_custom_field_5_label))
				<div class="textbox-info">
					<p class="f-left"><strong>
						{!!$receipt_details->shipping_custom_field_5_label!!} 
					</strong></p>
					<p class="f-right">
						{!!$receipt_details->shipping_custom_field_5_value ?? ''!!}
					</p>
				</div>
			@endif
			@if(!empty($receipt_details->sale_orders_invoice_no))
				<div class="textbox-info">
					<p class="f-left"><strong>
						@lang('restaurant.order_no')
					</strong></p>
					<p class="f-right">
						{!!$receipt_details->sale_orders_invoice_no ?? ''!!}
					</p>
				</div>
			@endif

			@if(!empty($receipt_details->sale_orders_invoice_date))
				<div class="textbox-info" style="margin-left: 2px ">
					<p class="f-left"><strong>
						@lang('lang_v1.order_dates')
					</strong></p>
					<p class="f-right">
						{!!$receipt_details->sale_orders_invoice_date ?? ''!!}
					</p>
				</div>
			@endif

            <table style="margin-top: 1px;margin-left: 1px !important;" class="border-bottom width-100 table-f-12 mb-10">
                <thead class="border-bottom-dotted" style="margin-top: 1px !important">
                    <tr>
                        
                        <th class="description" width="30%" style="font-size: 9px;font-weight: bold;">
                        	{{$receipt_details->table_product_label}}
                        </th>
                        <th class="MRP text-right"style="font-size: 9px;font-weight: bold;" >Wst</th>
                        <th class="quantity text-right" style="font-size: 9px;">
                        	{{$receipt_details->table_qty_label}}
                        </th>
                        @if(empty($receipt_details->hide_price))
                        <th class="unit_price text-right" style="font-size: 9px;">
                        	{{$receipt_details->table_unit_price_label}}
                        </th>
@endif
                        @if(!empty($receipt_details->item_discount_label))
							<th class="text-right" width="10%" style="font-size: 9px;">{{$receipt_details->item_discount_label}}</th>
						@endif

                        @if(!empty($receipt_details->table_subtotal_label))
                        <th class="price text-right" style="font-size: 9px;">{{$receipt_details->table_subtotal_label}}</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                	
                	 @php $product_saving = [];  @endphp
                	@forelse($receipt_details->lines as $line)
                	 @php
                        $mrp = $line['unit_price_before_discount_uf'];
                        if(isset($line['product_custom_fields'])) {
                            if($line['product_custom_fields']) {
                                $c_arr = explode(',', $line['product_custom_fields']);
                                $mtemp = isset($c_arr[0])? $c_arr[0]:0;
                                if($mtemp) {
                                    $mrp = $mtemp;
                                }
                                if(isset($c_arr[1])) {
                                    unset($c_arr[0]);
                                    $line['product_custom_fields'] = implode(', ', $c_arr);
                                } else {
                                    $line['product_custom_fields'] = '';
                                }
                            }
                        }
                        
                        $mrp_total = $mrp*$line['quantity_uf'];
                        //echo $mrp_total; exit;
                        if($mrp_total>($line['unit_price_before_discount_uf']*$line['quantity_uf'])) {
                            $product_saving[] = $mrp_total - ($line['unit_price_before_discount_uf']*$line['quantity_uf']);
                        } else {
                            $product_saving[] = 0;
                        }
                        
                    @endphp
                	 
	                    <tr>
	                        <!-- <td class="serial_number" style="vertical-align: top;">
	                        	{{$loop->iteration}}
	                        </td> -->
	                        <td class="description" style="font-size: 7px;font-weight: bold;">
	                        	{{$line['name']}} 
	                        	
	                        
	                        	
	                           
	                        </td>
	                        <td class="text-right" style="font-size: 7px;font-weight: bold;">{{$mrp}}</td>
	                        <td class="quantity text-right" style="font-size: 7px;">{{$line['quantity']}}</td>
	                        @if(empty($receipt_details->hide_price))
	                        <td class="unit_price text-right" style="font-size: 7px;font-weight: bold;">{{$line['unit_price_before_discount']}}</td>
	                         @endif
	                        <td class="price text-right" style="font-size: 7px;font-weight: bold;">{{$line['line_total']}}</td>
	                        
	                    </tr>
	                  
                    @endforeach
                    
                   

                </tbody>
            </table>
				@if(!empty($receipt_details->total_quantity_label))
				<div class="flex-box">
				<p class="width-40 text-right sub-headings">
						{!! $receipt_details->total_quantity_label !!}
					</p>
					<p class="width-40 text-right sub-headings">
						{{$receipt_details->total_quantity}}
					</p>
				</div>
			@endif
			@if(empty($receipt_details->hide_price))
                <div class="flex-box">
                    <p class="left text-right sub-headings">
                    	{!! $receipt_details->subtotal_label !!}
                    </p>
                    <p class="width-40 text-right sub-headings">
                    	{{$receipt_details->subtotal}}
                    </p>
                </div>

                <!-- Shipping Charges -->
				@if(!empty($receipt_details->shipping_charges))
					<div class="flex-box">
						<p class="left text-right">
							Making Charge
						</p>
						<p class="width-40 text-right">
							{{$receipt_details->shipping_charges}}
						</p>
					</div>
				@endif

				@if(!empty($receipt_details->packing_charge))
					<div class="flex-box">
						<p class="left text-right">
							{!! $receipt_details->packing_charge_label !!}
						</p>
						<p class="width-40 text-right">
							{{$receipt_details->packing_charge}}
						</p>
					</div>
				@endif

			


				@if(!empty($receipt_details->reward_point_label) )
					<div class="flex-box">
						<p class="width-40 text-right">
							{!! $receipt_details->reward_point_label !!}
						</p>

						<p class="width-40 text-right">
							(-) {{$receipt_details->reward_point_amount}}
						</p>
					</div>
				@endif

				@if( !empty($receipt_details->tax) )
					<div class="flex-box">
						<p class="width-40 text-right">
							{!! $receipt_details->tax_label !!}
						</p>
						<p class="width-40 text-right">
							(+) {{$receipt_details->tax}}
						</p>
					</div>
				@endif

				@if( $receipt_details->round_off_amount > 0)
					<div class="flex-box">
						<p class="width-40 text-right">
							{!! $receipt_details->round_off_label !!} 
						</p>
						<p class="width-40 text-right">
							{{$receipt_details->round_off}}
						</p>
					</div>
				@endif

				<div class="flex-box">
					<p class="width-40 text-right sub-headings">
						{!! $receipt_details->total_label !!}
					</p>
					<p class="width-40 text-right sub-headings">
						{{$receipt_details->total}}
					</p>
				</div>
				
			<!-- 	@if(!empty($receipt_details->payments))
					@foreach($receipt_details->payments as $payment)
						<div class="flex-box">
							<p class="width-40 text-right">{{$payment['method']}} ({{$payment['date']}}) </p>
							<p class="width-40 text-right">{{$payment['amount']}}</p>
						</div>
					@endforeach
				@endif -->

				<!-- Total Paid-->
				

				<!-- Total Due-->
				@if(!empty($receipt_details->total_due))
					<div class="flex-box">
						<p class="width-40 text-right sub-headings">
							{!! $receipt_details->total_due_label !!}
						</p>
						<p class="width-40 text-right sub-headings">
							{{$receipt_details->total_due}}
						</p>
					</div>
				@endif
			<!-- 	@if(!empty($receipt_details->total_in_words))
				<p colspan="2" class="text-right mb-0">
					<small>
					({{$receipt_details->total_in_words}})
					</small>
				</p>
				@endif -->
@php 
        $saving = 0.00;
        if($product_saving) {
            $saving = array_sum($product_saving);
        }
        if($saving>0.001) {
            $total_saving = $saving;
        } else {
            $total_saving = '0.00';
        }
        
    @endphp
   	<div class="flex-box">
     <p class="width-40 text-right sub-headings">Total Savings</p> : <p class="width-40 text-right sub-headings">₹ {{$total_saving}}</p>
    </div>
				@if(!empty($receipt_details->all_due))
					<div class="flex-box">
						<p class="width-40 text-right">
							{!! $receipt_details->all_bal_label !!}
						</p>
						<p class="width-40 text-right">
							{{$receipt_details->all_due}}
						</p>
					</div>
				@endif
			@endif
            <div class="border-bottom width-100">&nbsp;</div>
            @if(empty($receipt_details->hide_price))
	            <!-- tax -->
	            @if(!empty($receipt_details->taxes))
	            	<table class="border-bottom width-100 table-f-12">
	            		@foreach($receipt_details->taxes as $key => $val)
	            			<tr>
	            				<td class="left">{{$key}}</td>
	            				<td class="right">{{$val}}</td>
	            			</tr>
	            		@endforeach
	            	</table>
	            @endif
            @endif

 
            @if(!empty($receipt_details->additional_notes))
	            <p class="centered" >
	            	{!! nl2br($receipt_details->additional_notes) !!}
	            </p>
            @endif

            {{-- Barcode --}}
			@if($receipt_details->show_barcode)
				<br/>
				<img class="center-block" src="data:image/png;base64,{{DNS1D::getBarcodePNG($receipt_details->invoice_no, 'C128', 2,30,array(39, 48, 54), true)}}">
			@endif

			@if($receipt_details->show_qr_code && !empty($receipt_details->qr_code_details))
				@php
					$qr_code_text = implode(', ', $receipt_details->qr_code_details);
				@endphp
				<img class="center-block mt-5" src="data:image/png;base64,{{DNS2D::getBarcodePNG($qr_code_text, 'QRCODE')}}">
			@endif
			
			@if(!empty($receipt_details->footer_text))
				<p class="centered">
					{!! $receipt_details->footer_text !!}
				</p>
			@endif
			
        </div>
        <!-- <button id="btnPrint" class="hidden-print">Print</button>
        <script src="script.js"></script> -->
    </body>
</html>
<style type="text/css">
.f-8 {
	font-size: 8px !important;
}
@media print {
	* {
    	font-size: 8px;
    	font-family:verdana, arial, sans-serif;
    	word-wrap: break-word;
    	
	}
	.f-8 {
		
	}
	
.headings{
	font-size: 10px;
	font-size:bold;
}

.sub-headings{
	font-size: 15px !important;
	font-weight: 500 !important;
}

.border-top{
    border-top: 1px solid #242424;
}
.border-bottom{
	border-bottom: 1px solid #242424;
}

.border-bottom-dotted{
	border-bottom: 1px dotted black;
}
.text-box {
	width: 100%;
	height: auto;
}

.textbox-info {
	clear: both;
	font-family:verdana, arial, sans-serif;
}
.textbox-info p {
	margin-bottom: -1px;
	margin-left: 2px ;
	font-family:verdana, arial, sans-serif;
}
.flex-box {
	display: flex;
	width: 100%;
	font-family:verdana, arial, sans-serif;
	/*border-bottom: 1px dotted black;*/
}
.flex-box p {
	width: 50%;
	margin-bottom: 0px;
	white-space: nowrap;
	font-family:verdana, arial, sans-serif;
}

.table-f-12 th, .table-f-12 td {
	font-size: 12px;
	word-wrap: break-word;
	/*border-bottom: 1px dotted black;*/
}

.bw {
	word-wrap: break-word;
}
.centered {
    text-align: center;
    align-content: center;
    	font-family:verdana, arial, sans-serif;
}

.ticket {
    width: 100%;
    max-width: 100%;
    border-bottom: 1px dotted black;
}

img {
    max-width: inherit;
    width: auto;
}
</style>